#modname "Sombre Warhammer Poptype 1.8"
#description "A submod to allow Sombre's Warhammer nations to replace independent recruitables and independent province defence with national recruitables and PD. This mod only works in conjunction with and REQUIRES the Sombre Warhammer mod. It is included in the Sombre Warhammer modpack on the Steam Workshop.

Compatibility: Uses poptype IDs 153-179."
#icon "./poptype_logo.tga"
#version 1.8

-- version 1.8
-- added support for Cathay

-- version 1.7
-- added support for Strigos submod

-- version 1.6
-- removed recruitment from the national poptypes, replaced with national foreign recruitment to avoid some annoying bugs around fort sieging and storming

-- version 1.5
-- Tzeentch added

-- version 1.4
-- Black Crag got an additional poptype for cave provinces, consisting of nightgoblins

-- version 1.31
-- high elves got heavier archers added as a troop recruit


-- Version 1.3
-- fixed the nation ID used by Nurgle
-- middenheim get 20 spearmen per 10 PD rather than 15
-- high elves got a captain recruitable in their poptype and slightly improved PD

-- Version 1.2
-- fixed the ID number used by bone nose tribe

-- Version 1.1
-- added compatibility statement
-- merged with sombre warhammer as a workshop download, individual version removed


-- Version 1.0
-- update for dom6
-- Nation IDs done
-- poptype check done
-- monster ids done


-- #dependency Sombre_Warhammer.dm

-- the above line is needed by Kutcop's mod merger


------------------------ Poptype ID -- Nation ID -- nation name



----------------------------- 161 -- 152 -- High Elves
----------------------------- 162 -- 153 -- Tomb Kings
----------------------------- 163 -- 154 -- Vampires
----------------------------- 164 -- 156 -- Bretonnia
----------------------------- 165 -- 157 -- Tilea
----------------------------- 166 -- 158 -- Skaven
----------------------------- 167 -- 159 -- Dwarfs
----------------------------- 168 -- 163 -- Ogre Kingdoms
----------------------------- 169 -- 164 -- Chaos Dwarfs
----------------------------- 170 -- 165 -- Altdorf
----------------------------- 171 -- 166 -- Nuln
----------------------------- 172 -- 167 -- Middenheim
----------------------------- 173 -- 168 -- Itza
----------------------------- 174 -- 172 -- Nagashizzar
----------------------------- 160 -- 169 -- Slaanesh
----------------------------- 159 -- 160 -- Black Crag
----------------------------- 158 -- 161 -- Bone Nose
----------------------------- 157 -- 178 -- Dark Elves
----------------------------- 156 -- 151 -- Wood Elves
----------------------------- 155 -- 155 -- Beastmen
----------------------------- 154 -- 170 -- Khorne
----------------------------- 153 -- 171 -- Kislev
----------------------------- 175 -- 173 -- Nurgle
----------------------------- 176 -- 162 -- Norsca
----------------------------- 177 -- 160 -- Black Crag 2 (nightgoblins)
----------------------------- 178 -- 174 -- Tzeentch
----------------------------- 179 -- 175 -- Strigos
----------------------------- 180 -- 176 -- Cathay


------ KNOWN BUG

-- when a capital is taken and the capital is a cave province and the nation taking it doesn't replace cave poptypes, they seem to never reset the national poptype there to cavemen. I don't know why this is happening though


----- POPTYPES

-- Kislev

#selectpoptype 153
#clearrec
#cleardef
--addrecunit 13760 -- gospodar axeman
--addrecunit 13762 -- gospodar crossbowman
--addreccom 13739 -- Druzhinnik
#defcom1 13758 -- warrior priest of ursun
#defunit1 13760 -- gospodar axeman
#defunit1b 13762 -- gospodar crossbowman
#defmult1 10
#defmult1b 10
#end


-- Khorne

#selectpoptype 154
#clearrec
#cleardef
--addrecunit 16204 -- Marauder (montag)
--addrecunit 16203 -- Marauder Hunter (javelins, spear)
--addrecunit 16234 -- Marauder Horseman (javelin, light lance, shield)
--addreccom 16236 -- marauder scout
--addreccom 16259 -- Marauder chieftain
#defunit1 -1042 -- marauder montag
#defunit1b 16203 -- marauder hunter
#defmult1 10
#defmult1b 10
#end


-- Beastmen

#selectpoptype 155
#clearrec
#cleardef
#defunit1 -3222  -- Ungor montag
#defunit1b 15762 -- Ungor Raider with bow
#defunit1c 15763  -- Gor
#defmult1 20 -- 2 per point
#defmult1b 10 -- 1 per point
#defmult1c 10 -- 1 per point
#end


-- Wood Elves (athel loren)

#selectpoptype 156
#clearrec
#cleardef
--addrecunit 14131 -- Glade Guard
--addrecunit 14139 -- Glade Rider
--addreccom 14137 -- glade captain
#defunit1 14131 -- Glade Guard
#defunit1b 14143 -- dryad
#defmult1 10
#defmult1b 10
#end


-- Dark Elves (naggarond)

#selectpoptype 157
#clearrec
#cleardef
--addrecunit 15100  -- Dreadspear
--addrecunit 15103  -- Darkshard
--addreccom 15119 -- Master
#defunit1 15103 -- Darkshard
#defunit1b 15100 -- Dreadspear
#defmult1 10
#defmult1b 10
#end

-- Bone Nose Tribe

#selectpoptype 158
#clearrec
#cleardef
--addrecunit 13800 -- goblin montag
--addrecunit 13802 -- goblin archer
--addreccom 13964 -- goblin boss (SOUTH)
--addreccom 13900 -- goblin wolfrider scout
#defcom1 13957 -- orc boss (SOUTH)
#defunit1 -6552 -- goblin infantry montag
#defunit1b 13802 -- goblin archer
#defmult1 15
#defmult1b 15
#end

-- Black Crag

#selectpoptype 159
#clearrec
#cleardef
--addrecunit 13800 -- goblin montag
--addrecunit 13802 -- goblin archer
--addreccom 13912 -- goblin boss
--addreccom 13900 -- goblin wolfrider scout
#defcom1 13905 -- orc boss
#defunit1 -6552 -- goblin infantry montag
#defunit1b 13802 -- goblin archer
#defmult1 15
#defmult1b 15
#end

-- Black Crag 2

#selectpoptype 177
#clearrec
#cleardef
--addrecunit 13803 -- nightgoblin spear montag
--addrecunit 13804 -- nightgoblin archer montag
--addreccom 13919 -- nightgoblin boss
#defcom1 13919 -- nightgoblin boss
#defunit1 -6550 -- nightgoblin infantry montag
#defunit1b 13825 -- nightgoblin archer
#defmult1 15
#defmult1b 15
#end


-- Slaanesh

#selectpoptype 160
#clearrec
#cleardef
--addrecunit 14204 -- Marauder (recruitable montag)
--addrecunit 14203 -- Marauder Hunter (javelins, spear)
--addrecunit 14234 -- Marauder Horseman (javelin, light lance, shield)
--addreccom 14236 -- marauder scout
--addreccom 14259 -- Marauder chieftain
#defunit1 -1032 -- marauder montag
#defunit1b 14203 -- marauder hunter
#defmult1 10
#defmult1b 10
#end


-- High Elves (ulthuan)

#selectpoptype 161
#clearrec
#cleardef
--addrecunit 16002 -- Spearmen
--addrecunit 16001 -- light Archer
--addrecunit 16016 -- archer
--addreccom 16015 -- scout
--addreccom 14575 -- captain
#defunit1 16002 -- Spearmen
#defunit1b 16001 -- Archer
#defmult1 12
#defmult1b 12
#end

-- Tomb Kings (nehekhara)

#selectpoptype 162
#clearrec
#cleardef
--addreccom 15271 -- tomb herald
--addrecunit 15242 -- light spear
--addrecunit 15244 -- light infantry
--addrecunit 15246 -- light archer
--addrecunit 15248 -- warrior
#defcom1 15276 -- liche acolyte
#defunit1 15242 -- light spear
#defunit1b 15246 -- light archer
#defmult1 15
#defmult1b 10
#end

-- Vampires (vampiria)

#selectpoptype 163
#clearrec
#cleardef
--addrecunit 14102 -- Soulless montag recruit form
--addrecunit 14053 -- Longdead montag recruit form
--addreccom 14048 -- Vampire bat as scout
#defunit1 -6561 -- longdead montag
#defunit1b -6563 -- soulless montag
#defmult1 14
#defmult1b 24
#end


-- Bretonnia

#selectpoptype 164
#clearrec
#cleardef
--addrecunit 13662 -- Men-at-Arms (leather)
--addrecunit 13663 -- Men-at-Arms (chain)
--addrecunit 13665 -- Peasant Bowman
--addreccom 13675 -- Yeoman Outrider
--addreccom 13697 -- Paladin
#defcom1 13728 -- Grail Maiden
#defunit1 13662 -- Men-at-Arms (leather)
#defunit1b 13663 -- Men-at-Arms (chain)
#defunit1c 13665 -- Peasant Bowman
#defmult1 20
#defmult1b 10
#defmult1c 20
#end

-- Tilea

#selectpoptype 165
#clearrec
#cleardef
--addrecunit 15352 -- pikeman
--addrecunit 15353 -- crossbowman
--addreccom 15430 -- Scout
--addreccom 15368 -- merc captain
--addreccom 15431 -- Generic Priest
#defunit1 15352 -- pikeman
#defunit1b 15353 -- crossbowman
#defmult1 10
#defmult1b 10
#end

-- Skaven

#selectpoptype 166
#clearrec
#cleardef
--addrecunit 15542 -- Skavenslave with club
--addrecunit 15587 -- Skavenslave with spear and shield
--addrecunit 15551 -- Skavenslave slinger
--addrecunit 15541 -- Clanrat Spear
--addrecunit 15540 -- Clanrat Sword
--addreccom 15580 -- Scout
--addreccom 15560 -- Chieftain
#defcom1 15562 -- Moulder Packmaster
#defunit1 15541 -- Clanrat Spear
#defunit1b 15540 -- Clanrat Sword
#defunit1c 15551 -- Skavenslave slinger
#defmult1 20
#defmult1b 10
#defmult1c 10
#end

-- Dwarfs (karaz-a-karak)

#selectpoptype 167
#clearrec
#cleardef
--addrecunit 16100 -- Clansdwarf
--addrecunit 16102 -- Crossbowdwarf
--addreccom 16111 -- Thane
#defcom1 16127 -- Ancestor Stone
#defunit1 16100 -- Clansdwarf
#defunit1b 16102 -- Crossbowdwarf
#defmult1 10
#defmult1b 5
#end

-- Ogre Kingdoms (goldtooth tribe)

#selectpoptype 168
#clearrec
#cleardef
--addrecunit 15503 -- Gnoblar Fighter
--addrecunit 15500 -- Ogre Bull Club
--addrecunit 15501 -- Ogre Bull Ironfist
--addreccom 15527 -- Gnoblar Scout
--addreccom 15520 -- Ogre Bruiser
#defunit1 15503 -- Gnoblar Fighter
#defunit1b 15500 -- Ogre Bull Club
#defmult1 20
#defmult1b 8
#end

-- Chaos Dwarfs (zharr naggrund)

#selectpoptype 169
#clearrec
#cleardef
--addrecunit 18108 -- Hobgoblin Spearman
--addrecunit 18107 -- Hobgoblin Archer
--addrecunit 18100 -- Chaos Dwarf Warrior
--addreccom 18125 -- Hobgoblin Scout
--addreccom 18129 -- Castellan
#defcom1 18126 -- Hobgoblin Khan -- Sets the secondary commander for this poptype’s PD when PD is 20 or higher.
#defunit1 18107 -- Hobgoblin Archer
#defunit1b 18108 -- Hobgoblin Spearman
#defmult1 10
#defmult1b 20
#end

-- Altdorf

#selectpoptype 170
#clearrec
#cleardef
--addrecunit 17450 -- State Spearman
--addrecunit 17454 -- Archer
--addreccom 426 -- Scout
--addreccom 17436 -- State Captain
#defcom1 17437 -- Warrior Priest -- Sets the secondary commander for this poptype’s PD when PD is 20 or higher.
#defunit1 17450 -- State Spearman -- Sets the first type of unit in the poptype PD.
#defunit1b 17454 -- Archer -- Sets the second type of unit in the poptype PD.
#defunit1c 17453 -- state crossbow
#defmult1 10 -- Number of units per 10 points of defense. E.g. __#defmult1 20 will yield 2 units per point of defense, which is also the default.
#defmult1b 10 -- number of units per 10 points of defense for the second unit type.
#defmult1c 5 --
#end

-- Nuln

#selectpoptype 171
#clearrec
#cleardef
--addrecunit 17403 -- State Spearman (N)
--addrecunit 17399 -- Archer (N)
--addrecunit 17420 -- State Crossbowman (N)
--addreccom 426 -- Scout
--addreccom 17417 -- State Captain (N)
#defunit1 17403 -- State Spearman (N)
#defunit1b 17399 -- Archer (N)
#defunit1c 17420 -- State Crossbowman (N)
#defmult1 10
#defmult1b 5
#defmult1c 10
#end

-- Middenheim

#selectpoptype 172
#clearrec
#cleardef
--addrecunit 17502 -- State Spearman (Middenheim)
--addrecunit 17518 -- Archer (Middenheim)
--addreccom 426 -- Scout
--addreccom 17504 -- State Captain (Middenheim)
#defcom1 17522 -- Warrior Priest of Ulric (middenheim)
#defunit1 17502 -- State Spearman (Middenheim)
#defunit1b 17518 -- Archer (Middenheim)
#defmult1 20
#defmult1b 10
#end

-- Itza (lizardmen)

#selectpoptype 173
#clearrec
#cleardef
--addrecunit 17313 -- Skink Skirmisher (jav and shield)
--addrecunit 17312 -- Skink blowpipes
--addrecunit 17314 -- Skink Archer
--addreccom 17295 -- Skink Warchief
#defcom1 17295 -- Skink Warchief
#defunit1 17313 -- Skink Skirmisher (jav and shield)
#defunit1b 17312 -- Skink blowpipes
#defmult1 20
#defmult1b 20
#end

-- Nagashizzar (undead)

#selectpoptype 174
#clearrec
#cleardef
--addrecunit 13843 -- Soulless montag recruit form
--addrecunit 13783 -- Longdead montag recruit form
#defunit1 -6566 -- Longdead montag
#defunit1b 13798 -- Longdead Archer
#defmult1 15
#defmult1b 12
#end


-- Norsca

#selectpoptype 176
#clearrec
#cleardef
--addrecunit 17704 -- Thrall
--addrecunit 17702 -- Hunter
--addrecunit 17712 -- Warrior
#defunit1 17704 -- Thrall
#defunit1b 17702 -- Hunter
#defmult1 20
#defmult1b 10
#end


-- Nurgle

#selectpoptype 175
#clearrec
#cleardef
--addrecunit 15906 -- Marauder (recruitable montag)
--addrecunit 15908 -- Marauder Hunter (javelins, spear)
--addrecunit 15913 -- Marauder Light Horseman (javelin)
--addreccom 15981 -- marauder scout
--addreccom 15990 -- Marauder chieftain
#defunit1 -1012 -- marauder montag
#defunit1b 15908 -- Marauder Hunter (javelins, spear)
#defmult1 10
#defmult1b 10
#end


-- Tzeentch 178

#selectpoptype 178
#clearrec
#cleardef
#addrecunit 14693 -- Marauder (recruitable montag)
#addrecunit 14692 -- Marauder Hunter (javelins, spear)
#addrecunit 14713 -- Marauder Light Horseman (javelin)
#addreccom 14705 -- marauder scout
#addreccom 14698 -- Marauder chieftain
#defunit1 -1021 -- tzeentch marauder montag
#defunit1b 14692 -- Marauder Hunter (javelins, spear)
#defmult1 10
#defmult1b 10
#end

-- Strigos (Strigos)

#selectpoptype 179
#clearrec
#cleardef
--addrecunit 14102 -- Soulless montag recruit form
--addrecunit 14053 -- Longdead montag recruit form
--addreccom 14048 -- Vampire bat as scout
#defunit1 14851 -- strigany caravan guard
#defunit1b 14046 -- crypt ghoul
#defmult1 15
#defmult1b 20
#end

-- Cathay

#selectpoptype 180
#clearrec
#cleardef
#defunit1 14871 -- jade swordsman
#defunit1b 14873 -- jade crossbowman
#defmult1 10
#defmult1b 10
#end




----- POPTYPE EVENTS
-- Each nation needs an event that turns their own poptype into a suitable generic poptype. Then following that, an event that turns any province under their control into their poptype. That way if they control a province it has their poptype, if they don't then it doesn't


---- KISLEV

#newevent
#msg "kislev msg."
#nolog -- makes the event not appear in the log
#notext -- make the event not have any text
#rarity 5
#req_indepok 1 -- can happen in indy prov
#req_pop0ok -- can fire in provinces with low pop
#req_poptype 153
#setpoptype 28 -- commander, priest, militia, archer, heavy infantry recruitables -- PD: 1 archer, 1 militia, .5 infantry, commander at 20
#req_rare 50 -- each will have 50% chance
#end

#newevent
#msg "msg."
#nolog -- makes the event not appear in the log
#notext -- make the event not have any text
#rarity 5
#req_indepok 1 -- can happen in indy prov
#req_pop0ok -- can fire in provinces with low pop
#req_poptype 153
#setpoptype 50 -- scout, commander, priest, militia, light infantry, heavy infantry recruitables -- PD is PD: 1 militia, 1 light infantry, .5 heavy infantry, commander at 20
#end

#newevent
#msg "msg kislev poptype."
#nolog -- makes the event not appear in the log
#notext -- make the event not have any text
#rarity 5
#req_indepok 1 -- can happen in indy prov
#req_pop0ok -- can fire in provinces with low pop
#req_fornation 171
#req_owncapital 0 -- never triggers in own cap
#setpoptype 153
#req_cave 0 -- don't replace cave poptypes
#req_land 1 -- must be land
#end



---- KHORNE

#newevent
#msg "msg."
#nolog -- makes the event not appear in the log
#notext -- make the event not have any text
#rarity 5
#req_indepok 1 -- can happen in indy prov
#req_pop0ok -- can fire in provinces with low pop
#req_poptype 154
#setpoptype 28 -- commander, priest, militia, archer, heavy infantry recruitables -- PD: 1 archer, 1 militia, .5 infantry, commander at 20
#req_rare 50 -- each will have 50% chance
#end

#newevent
#msg "msg."
#nolog -- makes the event not appear in the log
#notext -- make the event not have any text
#rarity 5
#req_indepok 1 -- can happen in indy prov
#req_pop0ok -- can fire in provinces with low pop
#req_poptype 154
#setpoptype 50 -- scout, commander, priest, militia, light infantry, heavy infantry recruitables -- PD is PD: 1 militia, 1 light infantry, .5 heavy infantry, commander at 20
#end

#newevent
#msg "msg."
#nolog -- makes the event not appear in the log
#notext -- make the event not have any text
#rarity 5
#req_indepok 1 -- can happen in indy prov
#req_pop0ok -- can fire in provinces with low pop
#req_fornation 170
#req_owncapital 0 -- never triggers in own cap
#setpoptype 154
#req_cave 0 -- don't replace cave poptypes
#req_land 1 -- must be land
#end


---- NURGLE

#newevent
#msg "msg."
#nolog -- makes the event not appear in the log
#notext -- make the event not have any text
#rarity 5
#req_indepok 1 -- can happen in indy prov
#req_pop0ok -- can fire in provinces with low pop
#req_poptype 175
#setpoptype 28 -- commander, priest, militia, archer, heavy infantry recruitables -- PD: 1 archer, 1 militia, .5 infantry, commander at 20
#req_rare 50 -- each will have 50% chance
#end

#newevent
#msg "msg."
#nolog -- makes the event not appear in the log
#notext -- make the event not have any text
#rarity 5
#req_indepok 1 -- can happen in indy prov
#req_pop0ok -- can fire in provinces with low pop
#req_poptype 175
#setpoptype 50 -- scout, commander, priest, militia, light infantry, heavy infantry recruitables -- PD is PD: 1 militia, 1 light infantry, .5 heavy infantry, commander at 20
#end

#newevent
#msg "msg."
#nolog -- makes the event not appear in the log
#notext -- make the event not have any text
#rarity 5
#req_indepok 1 -- can happen in indy prov
#req_pop0ok -- can fire in provinces with low pop
#req_fornation 173 -- nurgle
#req_owncapital 0 -- never triggers in own cap
#setpoptype 175
#req_cave 0 -- don't replace cave poptypes
#req_land 1 -- must be land
#end



---- BEASTMEN

#newevent
#msg "msg."
#nolog -- makes the event not appear in the log
#notext -- make the event not have any text
#rarity 5
#req_indepok 1 -- can happen in indy prov
#req_pop0ok -- can fire in provinces with low pop
#req_poptype 155
#setpoptype 28 -- commander, priest, militia, archer, heavy infantry recruitables -- PD: 1 archer, 1 militia, .5 infantry, commander at 20
#req_rare 50 -- each will have 50% chance
#end

#newevent
#msg "msg."
#nolog -- makes the event not appear in the log
#notext -- make the event not have any text
#rarity 5
#req_indepok 1 -- can happen in indy prov
#req_pop0ok -- can fire in provinces with low pop
#req_poptype 155
#setpoptype 50 -- scout, commander, priest, militia, light infantry, heavy infantry recruitables -- PD is PD: 1 militia, 1 light infantry, .5 heavy infantry, commander at 20
#end

#newevent
#msg "msg."
#nolog -- makes the event not appear in the log
#notext -- make the event not have any text
#rarity 5
#req_indepok 1 -- can happen in indy prov
#req_pop0ok -- can fire in provinces with low pop
#req_fornation 155 -- beastmen
#setpoptype 155
#req_cave 0 -- don't replace cave poptypes
#req_land 1 -- must be land
#end





---- WOOD ELVES

#newevent
#msg "msg."
#nolog -- makes the event not appear in the log
#notext -- make the event not have any text
#rarity 5
#req_indepok 1 -- can happen in indy prov
#req_pop0ok -- can fire in provinces with low pop
#req_poptype 156
#setpoptype 28 -- commander, priest, militia, archer, heavy infantry recruitables -- PD: 1 archer, 1 militia, .5 infantry, commander at 20
#req_rare 50 -- each will have 50% chance
#end

#newevent
#msg "msg."
#nolog -- makes the event not appear in the log
#notext -- make the event not have any text
#rarity 5
#req_indepok 1 -- can happen in indy prov
#req_pop0ok -- can fire in provinces with low pop
#req_poptype 156
#setpoptype 50 -- scout, commander, priest, militia, light infantry, heavy infantry recruitables -- PD is PD: 1 militia, 1 light infantry, .5 heavy infantry, commander at 20
#end

#newevent
#msg "msg."
#nolog -- makes the event not appear in the log
#notext -- make the event not have any text
#rarity 5
#req_indepok 1 -- can happen in indy prov
#req_pop0ok -- can fire in provinces with low pop
#req_fornation 151
#req_owncapital 0 -- never triggers in own cap
#setpoptype 156
#req_cave 0 -- don't replace cave poptypes
#req_land 1 -- must be land
#end






---- DARK ELVES

#newevent
#msg "msg."
#nolog -- makes the event not appear in the log
#notext -- make the event not have any text
#rarity 5
#req_indepok 1 -- can happen in indy prov
#req_pop0ok -- can fire in provinces with low pop
#req_poptype 157
#setpoptype 28 -- commander, priest, militia, archer, heavy infantry recruitables -- PD: 1 archer, 1 militia, .5 infantry, commander at 20
#req_rare 50 -- each will have 50% chance
#end

#newevent
#msg "msg."
#nolog -- makes the event not appear in the log
#notext -- make the event not have any text
#rarity 5
#req_indepok 1 -- can happen in indy prov
#req_pop0ok -- can fire in provinces with low pop
#req_poptype 157
#setpoptype 50 -- scout, commander, priest, militia, light infantry, heavy infantry recruitables -- PD is PD: 1 militia, 1 light infantry, .5 heavy infantry, commander at 20
#end

#newevent
#msg "msg."
#nolog -- makes the event not appear in the log
#notext -- make the event not have any text
#rarity 5
#req_indepok 1 -- can happen in indy prov
#req_pop0ok -- can fire in provinces with low pop
#req_fornation 178
#req_owncapital 0 -- never triggers in own cap
#setpoptype 157
#req_cave 0 -- don't replace cave poptypes
#req_land 1 -- must be land
#end




---- GREENSKINS SOUTH (includes caves)

#newevent
#msg "msg."
#nolog -- makes the event not appear in the log
#notext -- make the event not have any text
#rarity 5
#req_indepok 1 -- can happen in indy prov
#req_pop0ok -- can fire in provinces with low pop
#req_poptype 158
#setpoptype 28 -- commander, priest, militia, archer, heavy infantry recruitables -- PD: 1 archer, 1 militia, .5 infantry, commander at 20
#req_rare 50 -- each will have 50% chance
#req_cave 0
#end

#newevent
#msg "msg."
#nolog -- makes the event not appear in the log
#notext -- make the event not have any text
#rarity 5
#req_indepok 1 -- can happen in indy prov
#req_pop0ok -- can fire in provinces with low pop
#req_poptype 158
#setpoptype 50 -- scout, commander, priest, militia, light infantry, heavy infantry recruitables -- PD is PD: 1 militia, 1 light infantry, .5 heavy infantry, commander at 20
#req_cave 0
#end

#newevent
#msg "msg."
#nolog -- makes the event not appear in the log
#notext -- make the event not have any text
#rarity 5
#req_indepok 1 -- can happen in indy prov
#req_pop0ok -- can fire in provinces with low pop
#req_poptype 158
#setpoptype 84 -- cavemen
#req_cave 1
#end

#newevent
#msg "msg."
#nolog -- makes the event not appear in the log
#notext -- make the event not have any text
#rarity 5
#req_indepok 1 -- can happen in indy prov
#req_pop0ok -- can fire in provinces with low pop
#req_fornation 161
#req_owncapital 0 -- never triggers in own cap
#setpoptype 158
#req_land 1 -- must be land
#end

---- BLACK CRAG (includes caves)

#newevent
#msg "msg."
#nolog -- makes the event not appear in the log
#notext -- make the event not have any text
#rarity 5
#req_indepok 1 -- can happen in indy prov
#req_pop0ok -- can fire in provinces with low pop
#req_poptype 159
#setpoptype 28 -- commander, priest, militia, archer, heavy infantry recruitables -- PD: 1 archer, 1 militia, .5 infantry, commander at 20
#req_rare 50 -- each will have 50% chance
#req_cave 0
#end

#newevent
#msg "msg."
#nolog -- makes the event not appear in the log
#notext -- make the event not have any text
#rarity 5
#req_indepok 1 -- can happen in indy prov
#req_pop0ok -- can fire in provinces with low pop
#req_poptype 159
#setpoptype 50 -- scout, commander, priest, militia, light infantry, heavy infantry recruitables -- PD is PD: 1 militia, 1 light infantry, .5 heavy infantry, commander at 20
#req_cave 0
#end

#newevent
#msg "msg."
#nolog -- makes the event not appear in the log
#notext -- make the event not have any text
#rarity 5
#req_indepok 1 -- can happen in indy prov
#req_pop0ok -- can fire in provinces with low pop
#req_poptype 159
#setpoptype 84 -- cavemen
#req_cave 1
#end

#newevent
#msg "msg."
#nolog -- makes the event not appear in the log
#notext -- make the event not have any text
#rarity 5
#req_indepok 1 -- can happen in indy prov
#req_pop0ok -- can fire in provinces with low pop
#req_poptype 177
#setpoptype 84 -- cavemen
#req_cave 1
#end


#newevent
#msg "msg."
#nolog -- makes the event not appear in the log
#notext -- make the event not have any text
#rarity 5
#req_indepok 1 -- can happen in indy prov
#req_pop0ok -- can fire in provinces with low pop
#req_fornation 160
#req_owncapital 0 -- never triggers in own cap
#setpoptype 159
#req_cave 0
#req_land 1 -- must be land
#end

#newevent
#msg "msg."
#nolog -- makes the event not appear in the log
#notext -- make the event not have any text
#rarity 5
#req_indepok 1 -- can happen in indy prov
#req_pop0ok -- can fire in provinces with low pop
#req_fornation 160
#req_owncapital 0 -- never triggers in own cap
#setpoptype 177
#req_cave 1
#req_land 1 -- must be land
#end


---- SLAANESH

#newevent
#msg "msg."
#nolog -- makes the event not appear in the log
#notext -- make the event not have any text
#rarity 5
#req_indepok 1 -- can happen in indy prov
#req_pop0ok -- can fire in provinces with low pop
#req_poptype 160
#setpoptype 28 -- commander, priest, militia, archer, heavy infantry recruitables -- PD: 1 archer, 1 militia, .5 infantry, commander at 20
#req_rare 50 -- each will have 50% chance
#end

#newevent
#msg "msg."
#nolog -- makes the event not appear in the log
#notext -- make the event not have any text
#rarity 5
#req_indepok 1 -- can happen in indy prov
#req_pop0ok -- can fire in provinces with low pop
#req_poptype 160
#setpoptype 50 -- scout, commander, priest, militia, light infantry, heavy infantry recruitables -- PD is PD: 1 militia, 1 light infantry, .5 heavy infantry, commander at 20
#end

#newevent
#msg "msg."
#nolog -- makes the event not appear in the log
#notext -- make the event not have any text
#rarity 5
#req_indepok 1 -- can happen in indy prov
#req_pop0ok -- can fire in provinces with low pop
#req_fornation 169
#req_owncapital 0 -- never triggers in own cap
#setpoptype 160
#req_cave 0 -- don't replace cave poptypes
#req_land 1 -- must be land
#end



---- ULTHUAN

#newevent
#msg "msg."
#nolog -- makes the event not appear in the log
#notext -- make the event not have any text
#rarity 5
#req_indepok 1 -- can happen in indy prov
#req_pop0ok -- can fire in provinces with low pop
#req_poptype 161
#setpoptype 28 -- commander, priest, militia, archer, heavy infantry recruitables -- PD: 1 archer, 1 militia, .5 infantry, commander at 20
#req_rare 50 -- each will have 50% chance
#end

#newevent
#msg "msg."
#nolog -- makes the event not appear in the log
#notext -- make the event not have any text
#rarity 5
#req_indepok 1 -- can happen in indy prov
#req_pop0ok -- can fire in provinces with low pop
#req_poptype 161
#setpoptype 50 -- scout, commander, priest, militia, light infantry, heavy infantry recruitables -- PD is PD: 1 militia, 1 light infantry, .5 heavy infantry, commander at 20
#end

#newevent
#msg "msg."
#nolog -- makes the event not appear in the log
#notext -- make the event not have any text
#rarity 5
#req_indepok 1 -- can happen in indy prov
#req_pop0ok -- can fire in provinces with low pop
#req_fornation 152
#req_owncapital 0 -- never triggers in own cap
#setpoptype 161
#req_cave 0 -- don't replace cave poptypes
#req_land 1 -- must be land
#end

---- TOMB KINGS (includes caves)

#newevent
#msg "msg."
#nolog -- makes the event not appear in the log
#notext -- make the event not have any text
#rarity 5
#req_indepok 1 -- can happen in indy prov
#req_pop0ok -- can fire in provinces with low pop
#req_poptype 162
#setpoptype 28 -- commander, priest, militia, archer, heavy infantry recruitables -- PD: 1 archer, 1 militia, .5 infantry, commander at 20
#req_rare 50 -- each will have 50% chance
#req_cave 0
#end

#newevent
#msg "msg."
#nolog -- makes the event not appear in the log
#notext -- make the event not have any text
#rarity 5
#req_indepok 1 -- can happen in indy prov
#req_pop0ok -- can fire in provinces with low pop
#req_poptype 162
#setpoptype 50 -- scout, commander, priest, militia, light infantry, heavy infantry recruitables -- PD is PD: 1 militia, 1 light infantry, .5 heavy infantry, commander at 20
#req_cave 0
#end

#newevent
#msg "msg."
#nolog -- makes the event not appear in the log
#notext -- make the event not have any text
#rarity 5
#req_indepok 1 -- can happen in indy prov
#req_pop0ok -- can fire in provinces with low pop
#req_poptype 162
#setpoptype 84 -- cavemen
#req_cave 1
#end

#newevent
#msg "msg."
#nolog -- makes the event not appear in the log
#notext -- make the event not have any text
#rarity 5
#req_indepok 1 -- can happen in indy prov
#req_pop0ok -- can fire in provinces with low pop
#req_fornation 153
#req_owncapital 0 -- never triggers in own cap
#setpoptype 162
#req_land 1 -- must be land
#end



---- VAMPIRES (includes caves)

#newevent
#msg "msg."
#nolog -- makes the event not appear in the log
#notext -- make the event not have any text
#rarity 5
#req_indepok 1 -- can happen in indy prov
#req_pop0ok -- can fire in provinces with low pop
#req_poptype 163
#setpoptype 28 -- commander, priest, militia, archer, heavy infantry recruitables -- PD: 1 archer, 1 militia, .5 infantry, commander at 20
#req_rare 50 -- each will have 50% chance
#req_cave 0
#end

#newevent
#msg "msg."
#nolog -- makes the event not appear in the log
#notext -- make the event not have any text
#rarity 5
#req_indepok 1 -- can happen in indy prov
#req_pop0ok -- can fire in provinces with low pop
#req_poptype 163
#setpoptype 50 -- scout, commander, priest, militia, light infantry, heavy infantry recruitables -- PD is PD: 1 militia, 1 light infantry, .5 heavy infantry, commander at 20
#req_cave 0
#end

#newevent
#msg "msg."
#nolog -- makes the event not appear in the log
#notext -- make the event not have any text
#rarity 5
#req_indepok 1 -- can happen in indy prov
#req_pop0ok -- can fire in provinces with low pop
#req_poptype 163
#setpoptype 84 -- cavemen
#req_cave 1
#end

#newevent
#msg "msg."
#nolog -- makes the event not appear in the log
#notext -- make the event not have any text
#rarity 5
#req_indepok 1 -- can happen in indy prov
#req_pop0ok -- can fire in provinces with low pop
#req_fornation 154
#req_owncapital 0 -- never triggers in own cap
#setpoptype 163
#req_land 1 -- must be land
#end





---- NAGASHIZZAR (includes caves)

#newevent
#msg "msg."
#nolog -- makes the event not appear in the log
#notext -- make the event not have any text
#rarity 5
#req_indepok 1 -- can happen in indy prov
#req_pop0ok -- can fire in provinces with low pop
#req_poptype 174
#setpoptype 28 -- commander, priest, militia, archer, heavy infantry recruitables -- PD: 1 archer, 1 militia, .5 infantry, commander at 20
#req_rare 50 -- each will have 50% chance
#req_cave 0
#end

#newevent
#msg "msg."
#nolog -- makes the event not appear in the log
#notext -- make the event not have any text
#rarity 5
#req_indepok 1 -- can happen in indy prov
#req_pop0ok -- can fire in provinces with low pop
#req_poptype 174
#setpoptype 50 -- scout, commander, priest, militia, light infantry, heavy infantry recruitables -- PD is PD: 1 militia, 1 light infantry, .5 heavy infantry, commander at 20
#req_cave 0
#end

#newevent
#msg "msg."
#nolog -- makes the event not appear in the log
#notext -- make the event not have any text
#rarity 5
#req_indepok 1 -- can happen in indy prov
#req_pop0ok -- can fire in provinces with low pop
#req_poptype 174
#setpoptype 84 -- cavemen
#req_cave 1
#end

#newevent
#msg "msg."
#nolog -- makes the event not appear in the log
#notext -- make the event not have any text
#rarity 5
#req_indepok 1 -- can happen in indy prov
#req_pop0ok -- can fire in provinces with low pop
#req_fornation 172
#req_owncapital 0 -- never triggers in own cap
#setpoptype 174
#req_land 1 -- must be land
#end







---- BRETONNIA

#newevent
#msg "msg."
#nolog -- makes the event not appear in the log
#notext -- make the event not have any text
#rarity 5
#req_indepok 1 -- can happen in indy prov
#req_pop0ok -- can fire in provinces with low pop
#req_poptype 164
#setpoptype 28 -- commander, priest, militia, archer, heavy infantry recruitables -- PD: 1 archer, 1 militia, .5 infantry, commander at 20
#req_rare 50 -- each will have 50% chance
#end

#newevent
#msg "msg."
#nolog -- makes the event not appear in the log
#notext -- make the event not have any text
#rarity 5
#req_indepok 1 -- can happen in indy prov
#req_pop0ok -- can fire in provinces with low pop
#req_poptype 164
#setpoptype 50 -- scout, commander, priest, militia, light infantry, heavy infantry recruitables -- PD is PD: 1 militia, 1 light infantry, .5 heavy infantry, commander at 20
#end

#newevent
#msg "msg."
#nolog -- makes the event not appear in the log
#notext -- make the event not have any text
#rarity 5
#req_indepok 1 -- can happen in indy prov
#req_pop0ok -- can fire in provinces with low pop
#req_fornation 156
#req_owncapital 0 -- never triggers in own cap
#setpoptype 164
#req_cave 0 -- don't replace cave poptypes
#req_land 1 -- must be land
#end


---- TILEA

#newevent
#msg "msg."
#nolog -- makes the event not appear in the log
#notext -- make the event not have any text
#rarity 5
#req_indepok 1 -- can happen in indy prov
#req_pop0ok -- can fire in provinces with low pop
#req_poptype 165
#setpoptype 28 -- commander, priest, militia, archer, heavy infantry recruitables -- PD: 1 archer, 1 militia, .5 infantry, commander at 20
#req_rare 50 -- each will have 50% chance
#end

#newevent
#msg "msg."
#nolog -- makes the event not appear in the log
#notext -- make the event not have any text
#rarity 5
#req_indepok 1 -- can happen in indy prov
#req_pop0ok -- can fire in provinces with low pop
#req_poptype 165
#setpoptype 50 -- scout, commander, priest, militia, light infantry, heavy infantry recruitables -- PD is PD: 1 militia, 1 light infantry, .5 heavy infantry, commander at 20
#end

#newevent
#msg "msg."
#nolog -- makes the event not appear in the log
#notext -- make the event not have any text
#rarity 5
#req_indepok 1 -- can happen in indy prov
#req_pop0ok -- can fire in provinces with low pop
#req_fornation 157
#req_owncapital 0 -- never triggers in own cap
#setpoptype 165
#req_cave 0 -- don't replace cave poptypes
#req_land 1 -- must be land
#end


---- SKAVEN (includes caves)

#newevent
#msg "msg."
#nolog -- makes the event not appear in the log
#notext -- make the event not have any text
#rarity 5
#req_indepok 1 -- can happen in indy prov
#req_pop0ok -- can fire in provinces with low pop
#req_poptype 166
#setpoptype 28 -- commander, priest, militia, archer, heavy infantry recruitables -- PD: 1 archer, 1 militia, .5 infantry, commander at 20
#req_rare 50 -- each will have 50% chance
#req_cave 0
#end

#newevent
#msg "msg."
#nolog -- makes the event not appear in the log
#notext -- make the event not have any text
#rarity 5
#req_indepok 1 -- can happen in indy prov
#req_pop0ok -- can fire in provinces with low pop
#req_poptype 166
#setpoptype 50 -- scout, commander, priest, militia, light infantry, heavy infantry recruitables -- PD is PD: 1 militia, 1 light infantry, .5 heavy infantry, commander at 20
#req_cave 0
#end

#newevent
#msg "msg."
#nolog -- makes the event not appear in the log
#notext -- make the event not have any text
#rarity 5
#req_indepok 1 -- can happen in indy prov
#req_pop0ok -- can fire in provinces with low pop
#req_poptype 166
#setpoptype 84 -- cavemen
#req_cave 1
#end

#newevent
#msg "msg."
#nolog -- makes the event not appear in the log
#notext -- make the event not have any text
#rarity 5
#req_indepok 1 -- can happen in indy prov
#req_pop0ok -- can fire in provinces with low pop
#req_fornation 158
#req_owncapital 0 -- never triggers in own cap
#req_owncapital 0 -- never triggers in own cap
#setpoptype 166
#req_land 1 -- must be land
#end


---- DWARFS (includes caves)

#newevent
#msg "msg."
#nolog -- makes the event not appear in the log
#notext -- make the event not have any text
#rarity 5
#req_indepok 1 -- can happen in indy prov
#req_pop0ok -- can fire in provinces with low pop
#req_poptype 167
#setpoptype 28 -- commander, priest, militia, archer, heavy infantry recruitables -- PD: 1 archer, 1 militia, .5 infantry, commander at 20
#req_rare 50 -- each will have 50% chance
#req_cave 0
#end

#newevent
#msg "msg."
#nolog -- makes the event not appear in the log
#notext -- make the event not have any text
#rarity 5
#req_indepok 1 -- can happen in indy prov
#req_pop0ok -- can fire in provinces with low pop
#req_poptype 167
#setpoptype 50 -- scout, commander, priest, militia, light infantry, heavy infantry recruitables -- PD is PD: 1 militia, 1 light infantry, .5 heavy infantry, commander at 20
#req_cave 0
#end

#newevent
#msg "msg."
#nolog -- makes the event not appear in the log
#notext -- make the event not have any text
#rarity 5
#req_indepok 1 -- can happen in indy prov
#req_pop0ok -- can fire in provinces with low pop
#req_poptype 167
#setpoptype 84 -- cavemen
#req_cave 1
#end

#newevent
#msg "msg."
#nolog -- makes the event not appear in the log
#notext -- make the event not have any text
#rarity 5
#req_indepok 1 -- can happen in indy prov
#req_pop0ok -- can fire in provinces with low pop
#req_fornation 159
#req_owncapital 0 -- never triggers in own cap
#setpoptype 167
#req_land 1 -- must be land
#end


---- OGRES (includes caves)

#newevent
#msg "msg."
#nolog -- makes the event not appear in the log
#notext -- make the event not have any text
#rarity 5
#req_indepok 1 -- can happen in indy prov
#req_pop0ok -- can fire in provinces with low pop
#req_poptype 168
#setpoptype 28 -- commander, priest, militia, archer, heavy infantry recruitables -- PD: 1 archer, 1 militia, .5 infantry, commander at 20
#req_rare 50 -- each will have 50% chance
#req_cave 0
#end

#newevent
#msg "msg."
#nolog -- makes the event not appear in the log
#notext -- make the event not have any text
#rarity 5
#req_indepok 1 -- can happen in indy prov
#req_pop0ok -- can fire in provinces with low pop
#req_poptype 168
#setpoptype 50 -- scout, commander, priest, militia, light infantry, heavy infantry recruitables -- PD is PD: 1 militia, 1 light infantry, .5 heavy infantry, commander at 20
#req_cave 0
#end

#newevent
#msg "msg."
#nolog -- makes the event not appear in the log
#notext -- make the event not have any text
#rarity 5
#req_indepok 1 -- can happen in indy prov
#req_pop0ok -- can fire in provinces with low pop
#req_poptype 168
#setpoptype 84 -- cavemen
#req_cave 1
#end

#newevent
#msg "msg."
#nolog -- makes the event not appear in the log
#notext -- make the event not have any text
#rarity 5
#req_indepok 1 -- can happen in indy prov
#req_pop0ok -- can fire in provinces with low pop
#req_fornation 163
#req_owncapital 0 -- never triggers in own cap
#setpoptype 168
#req_land 1 -- must be land
#end



---- CHAOS DWARFS (includes caves)

#newevent
#msg "msg."
#nolog -- makes the event not appear in the log
#notext -- make the event not have any text
#rarity 5
#req_indepok 1 -- can happen in indy prov
#req_pop0ok -- can fire in provinces with low pop
#req_poptype 169
#setpoptype 28 -- commander, priest, militia, archer, heavy infantry recruitables -- PD: 1 archer, 1 militia, .5 infantry, commander at 20
#req_rare 50 -- each will have 50% chance
#req_cave 0
#end

#newevent
#msg "msg."
#nolog -- makes the event not appear in the log
#notext -- make the event not have any text
#rarity 5
#req_indepok 1 -- can happen in indy prov
#req_pop0ok -- can fire in provinces with low pop
#req_poptype 169
#setpoptype 50 -- scout, commander, priest, militia, light infantry, heavy infantry recruitables -- PD is PD: 1 militia, 1 light infantry, .5 heavy infantry, commander at 20
#req_cave 0
#end

#newevent
#msg "msg."
#nolog -- makes the event not appear in the log
#notext -- make the event not have any text
#rarity 5
#req_indepok 1 -- can happen in indy prov
#req_pop0ok -- can fire in provinces with low pop
#req_poptype 169
#setpoptype 84 -- cavemen
#req_cave 1
#end

#newevent
#msg "msg."
#nolog -- makes the event not appear in the log
#notext -- make the event not have any text
#rarity 5
#req_indepok 1 -- can happen in indy prov
#req_pop0ok -- can fire in provinces with low pop
#req_fornation 164
#req_owncapital 0 -- never triggers in own cap
#setpoptype 169
#req_land 1 -- must be land
#end




---- ALTDORF

#newevent
#msg "msg."
#nolog -- makes the event not appear in the log
#notext -- make the event not have any text
#rarity 5
#req_indepok 1 -- can happen in indy prov
#req_pop0ok -- can fire in provinces with low pop
#req_poptype 170 -- altdorf poptype
#setpoptype 28 -- commander, priest, militia, archer, heavy infantry recruitables -- PD: 1 archer, 1 militia, .5 infantry, commander at 20
#req_rare 50 -- each will have 50% chance
#end

#newevent
#msg "msg."
#nolog -- makes the event not appear in the log
#notext -- make the event not have any text
#rarity 5
#req_indepok 1 -- can happen in indy prov
#req_pop0ok -- can fire in provinces with low pop
#req_poptype 170 -- altdorf poptype
#setpoptype 50 -- scout, commander, priest, militia, light infantry, heavy infantry recruitables -- PD is PD: 1 militia, 1 light infantry, .5 heavy infantry, commander at 20
#end

#newevent
#msg "msg."
#nolog -- makes the event not appear in the log
#notext -- make the event not have any text
#rarity 5
#req_indepok 1 -- can happen in indy prov
#req_pop0ok -- can fire in provinces with low pop
#req_fornation 165 -- altdorf
#req_owncapital 0 -- never triggers in own cap
#setpoptype 170
#req_cave 0 -- don't replace cave poptypes
#req_land 1 -- must be land
#end


---- NULN

#newevent
#msg "msg."
#nolog -- makes the event not appear in the log
#notext -- make the event not have any text
#rarity 5
#req_indepok 1 -- can happen in indy prov
#req_pop0ok -- can fire in provinces with low pop
#req_poptype 171
#setpoptype 28 -- commander, priest, militia, archer, heavy infantry recruitables -- PD: 1 archer, 1 militia, .5 infantry, commander at 20
#req_rare 50 -- each will have 50% chance
#end

#newevent
#msg "msg."
#nolog -- makes the event not appear in the log
#notext -- make the event not have any text
#rarity 5
#req_indepok 1 -- can happen in indy prov
#req_pop0ok -- can fire in provinces with low pop
#req_poptype 171
#setpoptype 50 -- scout, commander, priest, militia, light infantry, heavy infantry recruitables -- PD is PD: 1 militia, 1 light infantry, .5 heavy infantry, commander at 20
#end

#newevent
#msg "msg."
#nolog -- makes the event not appear in the log
#notext -- make the event not have any text
#rarity 5
#req_indepok 1 -- can happen in indy prov
#req_pop0ok -- can fire in provinces with low pop
#req_fornation 166
#req_owncapital 0 -- never triggers in own cap
#setpoptype 171
#req_cave 0 -- don't replace cave poptypes
#req_land 1 -- must be land
#end


---- MIDDENHEIM

#newevent
#msg "msg."
#nolog -- makes the event not appear in the log
#notext -- make the event not have any text
#rarity 5
#req_indepok 1 -- can happen in indy prov
#req_pop0ok -- can fire in provinces with low pop
#req_poptype 172
#setpoptype 28 -- commander, priest, militia, archer, heavy infantry recruitables -- PD: 1 archer, 1 militia, .5 infantry, commander at 20
#req_rare 50 -- each will have 50% chance
#end

#newevent
#msg "msg."
#nolog -- makes the event not appear in the log
#notext -- make the event not have any text
#rarity 5
#req_indepok 1 -- can happen in indy prov
#req_pop0ok -- can fire in provinces with low pop
#req_poptype 172
#setpoptype 50 -- scout, commander, priest, militia, light infantry, heavy infantry recruitables -- PD is PD: 1 militia, 1 light infantry, .5 heavy infantry, commander at 20
#end

#newevent
#msg "msg."
#nolog -- makes the event not appear in the log
#notext -- make the event not have any text
#rarity 5
#req_indepok 1 -- can happen in indy prov
#req_pop0ok -- can fire in provinces with low pop
#req_fornation 167
#req_owncapital 0 -- never triggers in own cap
#setpoptype 172
#req_cave 0 -- don't replace cave poptypes
#req_land 1 -- must be land
#end


---- ITZA (LIZARDMEN)

#newevent
#msg "msg."
#nolog -- makes the event not appear in the log
#notext -- make the event not have any text
#rarity 5
#req_indepok 1 -- can happen in indy prov
#req_pop0ok -- can fire in provinces with low pop
#req_poptype 173
#setpoptype 28 -- commander, priest, militia, archer, heavy infantry recruitables -- PD: 1 archer, 1 militia, .5 infantry, commander at 20
#req_rare 50 -- each will have 50% chance
#end

#newevent
#msg "msg."
#nolog -- makes the event not appear in the log
#notext -- make the event not have any text
#rarity 5
#req_indepok 1 -- can happen in indy prov
#req_pop0ok -- can fire in provinces with low pop
#req_poptype 173
#setpoptype 50 -- scout, commander, priest, militia, light infantry, heavy infantry recruitables -- PD is PD: 1 militia, 1 light infantry, .5 heavy infantry, commander at 20
#end

#newevent
#msg "msg."
#nolog -- makes the event not appear in the log
#notext -- make the event not have any text
#rarity 5
#req_indepok 1 -- can happen in indy prov
#req_pop0ok -- can fire in provinces with low pop
#req_fornation 168
#req_owncapital 0 -- never triggers in own cap
#setpoptype 173
#req_cave 0 -- don't replace cave poptypes
#req_land 1 -- must be land
#end



---- NORSCA

#newevent
#msg "msg."
#nolog -- makes the event not appear in the log
#notext -- make the event not have any text
#rarity 5
#req_indepok 1 -- can happen in indy prov
#req_pop0ok -- can fire in provinces with low pop
#req_poptype 176
#setpoptype 28 -- commander, priest, militia, archer, heavy infantry recruitables -- PD: 1 archer, 1 militia, .5 infantry, commander at 20
#req_rare 50 -- each will have 50% chance
#end

#newevent
#msg "msg."
#nolog -- makes the event not appear in the log
#notext -- make the event not have any text
#rarity 5
#req_indepok 1 -- can happen in indy prov
#req_pop0ok -- can fire in provinces with low pop
#req_poptype 176
#setpoptype 50 -- scout, commander, priest, militia, light infantry, heavy infantry recruitables -- PD is PD: 1 militia, 1 light infantry, .5 heavy infantry, commander at 20
#end

#newevent
#msg "msg."
#nolog -- makes the event not appear in the log
#notext -- make the event not have any text
#rarity 5
#req_indepok 1 -- can happen in indy prov
#req_pop0ok -- can fire in provinces with low pop
#req_fornation 162
#req_owncapital 0 -- never triggers in own cap
#setpoptype 176
#req_cave 0 -- don't replace cave poptypes
#req_land 1 -- must be land
#end


---- TZEENTCH

#newevent
#msg "msg."
#nolog -- makes the event not appear in the log
#notext -- make the event not have any text
#rarity 5
#req_indepok 1 -- can happen in indy prov
#req_pop0ok -- can fire in provinces with low pop
#req_poptype 178
#setpoptype 28 -- commander, priest, militia, archer, heavy infantry recruitables -- PD: 1 archer, 1 militia, .5 infantry, commander at 20
#req_rare 50 -- each will have 50% chance
#end

#newevent
#msg "msg."
#nolog -- makes the event not appear in the log
#notext -- make the event not have any text
#rarity 5
#req_indepok 1 -- can happen in indy prov
#req_pop0ok -- can fire in provinces with low pop
#req_poptype 178
#setpoptype 50 -- scout, commander, priest, militia, light infantry, heavy infantry recruitables -- PD is PD: 1 militia, 1 light infantry, .5 heavy infantry, commander at 20
#end

#newevent
#msg "msg."
#nolog -- makes the event not appear in the log
#notext -- make the event not have any text
#rarity 5
#req_indepok 1 -- can happen in indy prov
#req_pop0ok -- can fire in provinces with low pop
#req_fornation 174
#req_owncapital 0 -- never triggers in own cap
#setpoptype 178
#req_cave 0 -- don't replace cave poptypes
#req_land 1 -- must be land
#end



---- STRIGOS

#newevent
#msg "msg."
#nolog -- makes the event not appear in the log
#notext -- make the event not have any text
#rarity 5
#req_indepok 1 -- can happen in indy prov
#req_pop0ok -- can fire in provinces with low pop
#req_poptype 179
#setpoptype 28 -- commander, priest, militia, archer, heavy infantry recruitables -- PD: 1 archer, 1 militia, .5 infantry, commander at 20
#req_rare 50 -- each will have 50% chance
#end

#newevent
#msg "msg."
#nolog -- makes the event not appear in the log
#notext -- make the event not have any text
#rarity 5
#req_indepok 1 -- can happen in indy prov
#req_pop0ok -- can fire in provinces with low pop
#req_poptype 179
#setpoptype 50 -- scout, commander, priest, militia, light infantry, heavy infantry recruitables -- PD is PD: 1 militia, 1 light infantry, .5 heavy infantry, commander at 20
#end

#newevent
#msg "msg."
#nolog -- makes the event not appear in the log
#notext -- make the event not have any text
#rarity 5
#req_indepok 1 -- can happen in indy prov
#req_pop0ok -- can fire in provinces with low pop
#req_fornation 175
#req_owncapital 0 -- never triggers in own cap
#setpoptype 179
#req_cave 0 -- don't replace cave poptypes
#req_land 1 -- must be land
#end


---- CATHAY

#newevent
#msg "cathay msg."
#nolog -- makes the event not appear in the log
#notext -- make the event not have any text
#rarity 5
#req_indepok 1 -- can happen in indy prov
#req_pop0ok -- can fire in provinces with low pop
#req_poptype 180
#setpoptype 28 -- commander, priest, militia, archer, heavy infantry recruitables -- PD: 1 archer, 1 militia, .5 infantry, commander at 20
#req_rare 50 -- each will have 50% chance
#end

#newevent
#msg "cathay msg."
#nolog -- makes the event not appear in the log
#notext -- make the event not have any text
#rarity 5
#req_indepok 1 -- can happen in indy prov
#req_pop0ok -- can fire in provinces with low pop
#req_poptype 180
#setpoptype 50 -- scout, commander, priest, militia, light infantry, heavy infantry recruitables -- PD is PD: 1 militia, 1 light infantry, .5 heavy infantry, commander at 20
#end

#newevent
#msg "msg cathay poptype."
#nolog -- makes the event not appear in the log
#notext -- make the event not have any text
#rarity 5
#req_indepok 1 -- can happen in indy prov
#req_pop0ok -- can fire in provinces with low pop
#req_fornation 176
#req_owncapital 0 -- never triggers in own cap
#setpoptype 180
#req_cave 0 -- don't replace cave poptypes
#req_land 1 -- must be land
#end


-- ALWAYS LEAVE A COUPLE OF BLANK LINES AT THE END OF THE DM FILE

